<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Visitor extends Model
{
    protected $fillable = [
        'full_name',
        'phone_number',
        'email',
        'company_name',
        'purpose',
        'host_id',
        'time_in',
        'time_out',
        'status',
    ];

    protected $casts = [
        'time_in' => 'datetime',
        'time_out' => 'datetime',
    ];

    /**
     * Get the staff member (host) for this visitor.
     */
    public function host(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'host_id');
    }

    /**
     * Get the notes for this visitor.
     */
    public function notes()
    {
        return $this->hasMany(VisitorNote::class);
    }
}
