<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('visitors', function (Blueprint $table) {
            // Add indexes for commonly queried columns
            $table->index('status', 'visitors_status_index');
            $table->index('time_in', 'visitors_time_in_index');
            $table->index('host_id', 'visitors_host_id_index');
            $table->index('time_out', 'visitors_time_out_index');
            
            // Composite index for common query patterns
            $table->index(['status', 'time_in'], 'visitors_status_time_in_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('visitors', function (Blueprint $table) {
            $table->dropIndex('visitors_status_index');
            $table->dropIndex('visitors_time_in_index');
            $table->dropIndex('visitors_host_id_index');
            $table->dropIndex('visitors_time_out_index');
            $table->dropIndex('visitors_status_time_in_index');
        });
    }
};
