<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Visitor Badge - {{ $visitor->full_name }}</title>
    <style>
        @media print {
            @page {
                size: 3.375in 2.125in; /* Standard badge size */
                margin: 0;
            }
            body {
                margin: 0;
                padding: 0;
            }
        }
        body {
            font-family: Arial, sans-serif;
            width: 3.375in;
            height: 2.125in;
            border: 2px solid #333;
            padding: 10px;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }
        .visitor-info {
            flex: 1;
        }
        .visitor-name {
            font-size: 20px;
            font-weight: bold;
            text-align: center;
            margin: 10px 0;
        }
        .company-name {
            font-size: 14px;
            text-align: center;
            color: #666;
            margin-bottom: 5px;
        }
        .purpose {
            font-size: 12px;
            text-align: center;
            color: #888;
        }
        .footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid #ccc;
            padding-top: 5px;
            margin-top: 10px;
        }
        .badge-id {
            font-size: 10px;
            color: #666;
        }
        .check-in-time {
            font-size: 10px;
            color: #666;
        }
        .qr-code {
            width: 50px;
            height: 50px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>VISITOR</h1>
    </div>
    <div class="visitor-info">
        <div class="visitor-name">{{ $visitor->full_name }}</div>
        <div class="company-name">{{ $visitor->company_name }}</div>
        <div class="purpose">{{ $visitor->purpose }}</div>
    </div>
    <div class="footer">
        <div class="badge-id">ID: {{ $badgeId }}</div>
        <div class="check-in-time">{{ $checkInTime }}</div>
    </div>
</body>
</html>
