<?php

use Illuminate\Support\Facades\Route;

// Serve React app for all non-API routes (SPA fallback)
// This allows React Router to handle client-side routing
Route::get('/{any}', function () {
    // Check if the request is for an API route (should be handled by api.php)
    if (request()->is('api/*')) {
        abort(404);
    }
    
    // Check if the request is for a static asset (CSS, JS, images, etc.)
    $requestPath = request()->path();
    $publicPath = public_path($requestPath);
    
    // If it's a file that exists, serve it directly
    if (file_exists($publicPath) && !is_dir($publicPath)) {
        return response()->file($publicPath);
    }
    
    // For all other routes, serve the React app's index.html
    // This allows React Router to handle client-side routing
    $indexPath = public_path('index.html');
    if (file_exists($indexPath)) {
        return response()->file($indexPath);
    }
    
    // Fallback to Laravel welcome page if React build doesn't exist
    return view('welcome');
})->where('any', '^(?!api).*$'); // Match everything except routes starting with 'api'
